let currentObjectURL = null;

function renderCode() {
    const code = document.getElementById('codeEditor').value.trim();
    if (!code) return;

    const preview = document.getElementById('previewContent');

    let finalContent = '';
    const isFullDoc = code.toLowerCase().includes('<head') || code.toLowerCase().includes('<body');

    if (!isFullDoc) {
        finalContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset="utf-8">
            <script src="https://cdn.tailwindcss.com?plugins=forms,typography"><\/script>
            <link href="https://fonts.googleapis.com/css2?family=Geist:wght@400;500;600;700&display=swap" rel="stylesheet">
            <style>
                body { 
                    font-family: 'Geist', sans-serif; 
                    margin: 0; 
                    padding: 24px;
                    background: #fff;
                    min-height: 100vh;
                    color: #111;
                }
                * { transition: all 0.2s ease-in-out; }
            </style>
        </head>
        <body>
            ${code}
        </body>
        </html>
    `;
    } else {
        finalContent = code;
        if (!code.toLowerCase().includes('tailwindcss.com')) {
            finalContent = code.replace('</head>', '<script src="https://cdn.tailwindcss.com?plugins=forms,typography"><\/script></head>');
        }
    }

    if (currentObjectURL) {
        URL.revokeObjectURL(currentObjectURL);
    }

    const blob = new Blob([finalContent], { type: 'text/html' });
    currentObjectURL = URL.createObjectURL(blob);
    preview.src = currentObjectURL;

    showToast();
}

function clearEditor() {
    document.getElementById('codeEditor').value = '';
    document.getElementById('previewContent').src = '';
}

function showToast() {
    const toast = document.getElementById('toast');
    toast.classList.add('visible');
    setTimeout(() => {
        toast.classList.remove('visible');
    }, 2000);
}

// Support for Tab key
const editor = document.getElementById('codeEditor');
if (editor) {
    editor.addEventListener('keydown', function (e) {
        if (e.key === 'Tab') {
            e.preventDefault();
            var start = this.selectionStart;
            var end = this.selectionEnd;
            this.value = this.value.substring(0, start) + "  " + this.value.substring(end);
            this.selectionStart = this.selectionEnd = start + 2;
        }
    });

    const renderBtn = document.querySelector('.btn-render');
    if (renderBtn) {
        renderBtn.addEventListener('click', renderCode);
    }

    editor.addEventListener('paste', () => setTimeout(renderCode, 150));
    if (editor.value) renderCode();
}
