// ZipIt Background Script
chrome.runtime.onInstalled.addListener(() => {
    // Chrome/Opera/Edge sidePanel behavior
    if (typeof chrome !== 'undefined' && chrome.sidePanel && chrome.sidePanel.setPanelBehavior) {
        chrome.sidePanel.setPanelBehavior({ openPanelOnActionClick: true })
            .catch((error) => console.error('SidePanel Behavior Error:', error));
        chrome.sidePanel.setOptions({ path: 'popup.html', enabled: true })
            .catch((error) => console.error('SidePanel Options Error:', error));
    }
});

// Handle clicking the extension icon if sidePanel isn't automatic
chrome.action.onClicked.addListener((tab) => {
    if (typeof chrome !== 'undefined' && chrome.sidePanel && chrome.sidePanel.open) {
        chrome.sidePanel.open({ tabId: tab.id }).catch(() => {
            // Fallback: If open fails, the manifest's default_popup will handle it
        });
    }
});
